#include "r2l.h"
#include <qstring.h>
#include <qfileinfo.h>
#include <qpainter.h>
#include <qkeycode.h>
#include <qapplication.h>

#include <unistd.h>
#include <stdlib.h>


int main( int argc, char ** argv )
{
    QApplication a( argc, argv );
    R2L b;
    a.setMainWidget( &b );
    b.show();
    return a.exec();
}

R2L::R2L( QWidget *parent, const char *name )
    : QWidget( parent, name, WType_Modal )
{
    QFileInfo fi( "/tmp/.rev" );
    startTimer( 1000 );

    //    setMinimumSize( 48, 48 );
    setMaximumSize( 48, 48 );
    resize( 48, 48 );
	
    hasNewMail.resize( 48, 48 );
    noNewMail.resize( 48, 48 );

    hasNewMail.fill( QColor( 255,0,0 ) );
    noNewMail.fill( QColor( 0,0,255 ) );

    gotMail = fi.exists();
}


void R2L::updatedisplay( void )
{
    QFileInfo fi( "/tmp/.rev" );
    bool newState = fi.exists();
    if ( newState != gotMail ) {
	gotMail = newState;
	repaint( FALSE );
    }
}
 

void R2L::timerEvent( QTimerEvent * )
{
  updatedisplay();
}
  

void R2L::paintEvent( QPaintEvent * )
{
    if ( gotMail )
	bitBlt( this, 0, 0, &hasNewMail );
    else
	bitBlt( this, 0, 0, &noNewMail );
}


void R2L::mousePressEvent( QMouseEvent * mouseevent)
{
    QFile fi( "/tmp/.rev" );
    
    switch(mouseevent->button()) {
      case MidButton:
	close( TRUE );
      break;
      case LeftButton:
	if(fi.exists()) {
	  fi.remove();
	  updatedisplay();
	}
      break;
      case RightButton:
	if(!fi.exists()) {
	  fi.open( IO_WriteOnly );
	  updatedisplay();
	}
       break;
      default:
      break;
    }
    
    updatedisplay();
}

void R2L::keyPressEvent( QKeyEvent * e )
{	  
  switch (e->key()) {
    case Key_Q:
      close( TRUE );
    break;
    case Key_T:{
        QFile fi( "/tmp/.rev" );
	if (fi.exists()) {
	  fi.remove();
	} else {
	  fi.open( IO_WriteOnly );
	}    
	updatedisplay();
    }
    break;
    case Key_L:{
        QFile fi( "/tmp/.rev" );
	if(fi.exists()) {
	  fi.remove();
	  updatedisplay();
	}
    }
    break;
    case Key_R: {
        QFile fi( "/tmp/.rev" );
	if(!fi.exists()) {
	  fi.open( IO_WriteOnly );
	  updatedisplay();
	}
    }
    break;
    default:
      e->ignore();
    break;
  }
}
