#include <stdio.h>

#include "bd.h"

int HEIGHT;
int DPI;
int left_skip;
int left_spare;
int top_skip;
int vis_width;
int vis_height;
int vis_pix_height;
int vis_pitch;
int display_width;
int display_height;
int display_pix_height;
int volatile_selection;

typedef struct {
	char name[32];
	int (*readval)(char *, void *);
	void *val;
} cfgline;

int readint(char *line, void *val) {
    int i,j;
    j=sscanf(line," %i",&i);
    if(j==1)*(int *)val=i;
    return j-1;
}

int readstring(char *line, void *val) {
    int j;    
    j= sscanf(line," %s ",(char *)val);
    return 0;
}

int set_one(char *line, void *val) {
    *(int *)val=1;
    return 0;
}

cfgline configs[]= {
	{ "print dpi", readint, &PDPI },
	{ "display dpi", readint, &DPI },
	{ "page width", readint, &page_width },
	{ "page height", readint, &page_height },
	{ "display width", readint, &display_width },
	{ "display height", readint, &display_pix_height },
	{ "top margin", readint, &page_bottom_margin },
	{ "bottom margin", readint, &page_top_margin },
	{ "right margin", readint, &page_right_margin },
	{ "left margin", readint, &page_left_margin },
	{ "autosave keys", readint, &autosavekeyinterval },
        { "font path", readstring, fontpath },
        { "print file", readstring, printfile},
        { "default file name", readstring, filename },
        { "template file name", readstring, template },
        { "volatile selection", set_one, &volatile_selection},

        { "", NULL, NULL }
};

int default_values() {

    page_width=8*72;
    page_height=11*72;
    page_right_margin=36;
    page_left_margin=36;
    page_top_margin=36;
    page_bottom_margin=36;
    
    PDPI=104;
    
    display_width=1024;
    display_pix_height=768;
    DPI=0;

    autosavekeyinterval=500;
    volatile_selection=0;
    
    strcpy(fontpath, "/usr/X11R6/lib/X11/fonts/ttfonts/:/dosc/windows/fonts/");
    strcpy(printfile, "/tmp/bd.ps");
    strcpy(filename, "/tmp/peace.bd");
    strcpy(template, "template");
    
    return 0;
}

int set_size() {

    WIDTH=page_width-page_right_margin-page_left_margin;
    HEIGHT=page_height-page_top_margin-page_bottom_margin;
    if((DPI==0) || ((DPI*WIDTH)/72>display_width-left_skip)) {
        DPI=(8*(display_width-left_skip)/WIDTH)*9;
    }
    UDPI=(display_width-left_skip)/63*9;

    if(UDPI>135)UDPI=135;
    if(UDPI<65)UDPI=65;

    vis_width=display_width-left_skip+left_spare;
    vis_pix_height=display_pix_height-top_skip;
    vis_height=vis_pix_height*72/DPI;

    if(screen_bpp!=0) {
        vis_pitch=vis_width*screen_bpp;
        screen_pitch=display_width*screen_bpp;
    }
    return 0;
}

int fix_values() {
    if(template[0]!='/') {
        char *c;
        char cfname[256];
        c=getenv("HOME");
        strcpy(cfname,c);
        strcat(cfname,"/.timna/");
        strcat(cfname,template);
        strncpy(template,cfname,127);
    }
    return 0;
}

int readconfigfile() {
    char line[1024], cfname[256];
    FILE *f;
    char *c;
    
    default_values();
    
    c=getenv("HOME");
    strcpy(cfname,c);
    strcat(cfname,"/.timna/config");

    f=fopen(cfname,"r");
    if(f) {
        while(fgets(line,1023,f)) {
            int i;
            
            i=0;
            while((i<strlen(line))&&(line[i]!='#'))i++;
            line[i]=0;
            i=0;
            while(configs[i].val && strncasecmp(configs[i].name,line,strlen(configs[i].name)))i++;
            if(configs[i].val) {
                configs[i].readval(line+strlen(configs[i].name),configs[i].val);
            }
        }
        fclose(f);
    }

    top_skip=50;
    left_skip=90;
    left_spare=40;

    fix_values();
    
    set_size();
    
    return 0;
}
