#include <unistd.h>
#include <stdio.h>
#include "bd.h"

char filename[128];
char template[128];
char autosavefilename[128];

int fit_par_width(par_t *par) {
    if(par->par_point_width+par->par_point_margin>WIDTH) {
        if(par->par_point_width<=WIDTH) {
            par->par_point_margin=WIDTH-par->par_point_width;
        } else {
            par->par_point_margin=0;
            par->par_point_width=WIDTH;            
        }
    }   
    return 0;
}

int save(char *filename, par_t *first_par) {
    FILE *file;
    int i, n, j;
    par_t *par;

    file=fopen(filename,"w");
    if(file==NULL)return -1;

    fprintf(file,"TIMNA 0.0\n");

/* number of lines to skip */
    fprintf(file,"%i\n",0);

    fprintf(file,"%i\n",fontsnum);
    for(i=0;i<fontsnum;i++){
        fprintf(file,"%i %i %i %s\n",
                (int)fonts[i]->height, (int)fonts[i]->width, 
                (int)fonts[i]->face->style_flags, fonts[i]->face->family_name);
    }

    n=0;
    par=first_par;
    while(par!=NULL) {
        n++;
        par=par->next;
    }
    fprintf(file,"%i\n",n);
    
    par=first_par;
    for(i=0;i<n;i++) {
        fprintf(file,"%i %i %i %i %i %i %i %i\n",par->par_point_width, par->style,
            	par->par_point_margin, par->numfontchanges, par->lineskip,
                par->firstlineskip, par->firstlineindent, par->numtabs);
        for(j=0;j<par->numfontchanges;j++) {
            fprintf(file,"%i %i\n",par->fontchangepos[j], par->fontchange[j]);
        }
        for(j=0;j<par->numtabs;j++) {
            fprintf(file,"%i\n",par->tabs[j]);
        }
        par=par->next;
    }

    par=first_par;
    for(i=0;i<n;i++) {
        fprintf(file,"%s\n",par->text);
        par=par->next;
    }
    
    fclose(file);
    return 0;
}

int load(char *filename) {
    FILE *file;
    int i,n,cp, ht, wd, st, j;
    par_t *par;
    char t[2048];
    int translate[256];
    int fnum;

    file=fopen(filename,"r");
    if(file==NULL)return -1;

    fgets(t,2047,file);
    t[strlen(t)-1]=0;
    if(strncmp(t,"TIMNA 0",7))return -1;

    fscanf(file,"%i\n",&n);
    for(i=0;i<n;i++){
        fgets(t,2047,file);
    }

    fscanf(file,"%i\n",&fnum);
    for(i=0;i<fnum;i++){
        fscanf(file,"%i %i %i ", &ht, &wd, &st);
        fgets(t,2047,file);
        t[strlen(t)-1]=0;
        translate[i]=open_font(t,st,ht,DPI);
    }

    fscanf(file,"%i\n",&n);

    for(i=0;i<n;i++) {
        par=new_par(NULL);
        insert_par(par,NULL);
        fgets(t,2047,file);
        sscanf(t,"%i %i %i %i %i %i %i %i\n", &par->par_point_width, &par->par_point_margin, 
               &par->style, &par->numfontchanges, &par->lineskip,
               &par->firstlineskip, &par->firstlineindent, &par->numtabs);
        fit_par_width(par);
        for(j=0;j<par->numfontchanges;j++) {
            fscanf(file,"%i %i\n",&par->fontchangepos[j], &cp);
            par->fontchange[j]=(cp&0xfffff000) | translate[cp&0xfff];
        }
        for(j=0;j<par->numtabs;j++) {
            fscanf(file,"%i\n",&par->tabs[j]);
        }
    }
    
    par=first_par;
    for(i=0;i<n;i++) {
        fgets(par->text,2047,file);
        par->cacheflags=0;
        par=par->next;
    }

    reformat(0,DPI,first_par);

    fclose(file);
    return 0;
}

int makeautosavename(char *autosave, char *fn) {
    char tmp[2040];
    int i;
    
    strcpy(autosave,getenv("HOME"));
    strcat(autosave,"/.timna/");
    if(fn[0]!='/') {
        getcwd(tmp,230);
        strcat(tmp,"_");
    } else tmp[0]=0;
    strcat(tmp,fn);
    for(i=0;i<strlen(tmp);i++)if(tmp[i]=='/')tmp[i]='_';
    strcat(autosave,tmp);
    
    return 0;
}
