#include "keys.h"

int mapkeys[128]= {
0,	K_ESC,	'1',	'2',	'3',	'4',	'5',	'6',
'7',	'8',	'9',	'0',	'-',	'=', K_BACKSPACE, K_TAB,
'q', 	'w',	'e',	'r',	't',	'y',	'u',	'i',
'o',	'p',	'[',	']',  K_ENTER,	0,	'a', 	's',
'd',	'f',	'g',	'h',	'j',	'k',	'l',	';',
39,	'`',	0,	'\\',	'z',	'x',	'c',	'v',
'b',	'n',	'm',	',',	'.',	'/',	0,	KP_MULT,
0,	' ',	0,	K_F1,	K_F2,	K_F3,	K_F4,	K_F5,
K_F6,	K_F7,	K_F8,	K_F9,	K_F10,	0,	0,	KP_7,
KP_8,	KP_9,	KP_MINUS, KP_4,	KP_5,	KP_6,	KP_PLUS, KP_1,
KP_2,	KP_3,	KP_0,	KP_PERIOD, 0,	0,	0,	K_F11,
K_F12,	0,	0,	0,	0,	0,	0,	0,
KP_ENTER, 0,	KP_SLASH, 0,	0, K_BREAK,	K_HOME, K_UP,
K_PGUP,	K_LEFT,	K_RIGHT, K_END, K_DOWN,	K_PGDOWN, K_INS, K_DEL,
0,	0,	0,	0,	0,	0,	0,	0,
0,	0,	0,	0,	0,	0,	0,	0	};

int shiftmapkeys[128]= {
0,	K_ESC,	'!',	'@',	'#',	'$',	'%',	'^',
'&',	'*',	'(',	')',	'_',	'+', K_BACKSPACE, K_TAB,
'Q', 	'W',	'E',	'R',	'T',	'Y',	'U',	'I',
'O',	'P',	'{',	'}',  K_ENTER,	0,	'A', 	'S',
'D',	'F',	'G',	'H',	'J',	'K',	'L',	':',
'"',	'~',	0,	'|',	'Z',	'X',	'C',	'V',
'B',	'N',	'M',	'<',	'>',	'?',	0,	KP_MULT,
0,	' ',	0,	K_F1,	K_F2,	K_F3,	K_F4,	K_F5,
K_F6,	K_F7,	K_F8,	K_F9,	K_F10,	0,	0,	KP_7,
KP_8,	KP_9,	KP_MINUS, KP_4,	KP_5,	KP_6,	KP_PLUS, KP_1,
KP_2,	KP_3,	KP_0,	KP_PERIOD, 0,	0,	0,	K_F11,
K_F12,	0,	0,	0,	0,	0,	0,	0,
KP_ENTER, 0,	KP_SLASH, 0,	0, K_BREAK,	K_HOME, K_UP,
K_PGUP,	K_LEFT,	K_RIGHT, K_END, K_DOWN,	K_PGDOWN, K_INS, K_DEL,
0,	0,	0,	0,	0,	0,	0,	0,
0,	0,	0,	0,	0,	0,	0,	0	};

int translate_keycode(int key, int shift) {
    int ch;
    
    if((shift&0xd)==1) {
        ch=shiftmapkeys[key];
    } else {
        ch=mapkeys[key];
    }

    if((shift&0xe)==2) {
        if((ch>='A')&&(ch<='Z'))ch+=32; else
        if((ch>='a')&&(ch<='z'))ch-=32;
    }
    
    switch(ch) {
        case KP_ENTER:
            ch=K_ENTER;
            break;
    }

    if(shift&4) {
        ch+=CONTROL;
    }

    if(shift&8) {
        ch+=ALT;
    }

    if((shift&1)&&(((shift&0xc)!=0)||(ch>255))) {
        ch+=SHIFT;
    }
    return ch;
}

int hebconv(int i) {
    int j;
    static unsigned char hebconvert[26]="ypabwkriogljvnmt/xc`ed'qhf";
    
    if(i>='a' && i<='z') {
        j=hebconvert[i-'a'];
        if(j>='`' && j<='z')j+=128;
        return j;
    } else switch(i) {
        case ';': return 's'+128; break;
        case '\'': return ','; break;
        case ',': return 'z'+128; break;
        case '.': return 'u'+128; break;
        case '/': return '.'; break;
        default: return i;
    }
}
   

