void loadsna(int n, struct prefs_t *prefs) {
	unsigned char s[28];
	unsigned char k[10];
	int i;

	for(i=0;i<9;i++)k[i]=144+i;

	if(n<dbsnapsnum) {
		FileDump(s, list[n], 0, 27);
		FileDump(memram, list[n], 27, 49152);
		FileDump(k, list[n], 27+49152, 9);
	} else {
		FileRef f;
		int err;
		
		err=VFSFileOpen(vfssnaps[n-dbsnapsnum].volRefNum, vfssnaps[n-dbsnapsnum].name, 
				vfsModeRead, &f);
		if(err==errNone) {
			VFSFileSeek(f, vfsOriginBeginning, 0);
			VFSFileRead(f, 27, s, NULL);
			VFSFileRead(f, 49152, memram, NULL);
			VFSFileClose(f);
		} else {
		}
	}

	armshared.a = s[22];
	armshared.f = s[21];
	armshared.b = s[14];
	armshared.c = s[13];
	armshared.d = s[12];
	armshared.e = s[11];
	armshared.h = s[10];
	armshared.l = s[9];
	armshared.r = s[20];
	armshared.i = s[0];
	armshared.im = s[25];
	armshared.iff1 = (s[19]&4)>>2;
	armshared.iff2 = (s[19]&4)>>2;
	armshared.sp = s[23]+256*s[24];
	armshared.ix = s[17]+256*s[18];
	armshared.iy = s[15]+256*s[16];
	armshared.a1 = s[8];
	armshared.f1 = s[7];
	armshared.b1 = s[6];
	armshared.c1 = s[5];
	armshared.d1 = s[4];
	armshared.e1 = s[3];
	armshared.h1 = s[2];
	armshared.l1 = s[1];
	armshared.out254 &= 0xf8;
	armshared.out254 |= s[26]&7;
	armshared.pc = memram[armshared.sp-0x4000]+256*memram[armshared.sp-0x3fff];
	armshared.sp += 2;

	i=0;

	if(!prefs->global) {
		if(k[0]==144) {
			while(hkeys[i].name[0]) {
				if(StrCaselessCompare(hkeys[i].name, list[n])==0) {
					MemMove(prefs->hardkeys, hkeys[i].keys, 9);
					return;
				}
				i++;
			}
		} else {
			MemMove(prefs->hardkeys, k, 9);
		}
	}
}

void savesna(char *name, struct prefs_t *prefs) {
	unsigned char s[28];
	unsigned char s1, s2;

	s[22] = armshared.a;
	s[21] = armshared.f;
	s[14] = armshared.b;
	s[13] = armshared.c;
	s[12] = armshared.d;
	s[11] = armshared.e;
	s[10] = armshared.h;
	s[9] = armshared.l;
	s[20] = armshared.r;
	s[0] = armshared.i;
	s[25] = armshared.im;
	s[19] = armshared.iff1<<2;
	s[8] = armshared.a1;
	s[7] = armshared.f1;
	s[6] = armshared.b1;
	s[5] = armshared.c1;
	s[4] = armshared.d1;
	s[3] = armshared.e1;
	s[2] = armshared.h1;
	s[1] = armshared.l1;
	s[26] = armshared.out254 & 7;
	armshared.sp-=2;
	s1=memram[armshared.sp-0x4000];
	s2=memram[armshared.sp-0x3fff];
	memram[armshared.sp-0x4000]=armshared.pc&0xff;
	memram[armshared.sp-0x3fff]=(armshared.pc>>8)&0xff;
	s[23]=armshared.sp&0xff;
	s[24]=(armshared.sp>>8)&0xff;
	s[15]=armshared.iy&0xff;
	s[16]=(armshared.iy>>8)&0xff;
	s[17]=armshared.ix&0xff;
	s[18]=(armshared.ix>>8)&0xff;

	FileCreate(TMP_FILE, 49152+27+9);
	filewrite(TMP_FILE, s, 0, 27);
	filewrite(TMP_FILE, memram, 27, 49152);
	filewrite(TMP_FILE, prefs->hardkeys, 27+49152, 9);

	memram[armshared.sp-0x4000]=s1;
	memram[armshared.sp-0x3fff]=s2;
	armshared.sp+=2;
}

void FreeListSNA(void)
{
	int n;
	if(nlist) {
		for(n = 0; n < nlist; n++) {
			MemPtrFree(list[n]);
		}
		MemPtrFree(list);
		nlist = 0;
	}
}

void getlistname(char *ln, const char *n) {
	int i, l;

	l=StrLen(n);
	i=l-1;
	while(i && n[i]!='/')i--;
	i++;
	if(l-i>31)i=l-31;
	if(StrCaselessCompare(n+l-4, ".sna")==0) {
		l-=4;
	}
	StrNCopy(ln, n+i, l-i);
	ln[l-i]='\0';
}

void GetListSNA(void)
{
	int lFirst;
	DmSearchStateType ss;
	UInt16 card;
	LocalID id;
	int n = 0, i, err;

	FileRef dirRef;
	UInt16 volRefNum; 
	UInt32 volIterator;
	
	volIterator = vfsIteratorStart; 
	
	if(vfssnaps)MemPtrFree(vfssnaps);
	vfssnaps = MemPtrNew(sizeof(struct vfssnap) * MAXVFSSNAPS);
	
	while (volIterator != vfsIteratorStop) { 
		err = VFSVolumeEnumerate(&volRefNum, &volIterator); 
		if (err == errNone) {
			err = VFSFileOpen(volRefNum, "/palm/programs/spec", vfsModeRead, &dirRef); 
			if(err == errNone) {  
				UInt32 fileIterator; 
				FileInfoType fileInfo; 
				char fileName[256];  

				fileInfo.nameP = fileName;
				fileInfo.nameBufLen = 256;
				fileIterator = vfsIteratorStart;
				while ( (fileIterator != vfsIteratorStop) && 
						(err==errNone) && (n<MAXVFSSNAPS) ){
					
					err = VFSDirEntryEnumerate(dirRef, &fileIterator, &fileInfo);
					if(err == errNone && !(fileInfo.attributes&vfsFileAttrDirectory)) {
						vfssnaps[n].volRefNum=volRefNum;
						sprintf(vfssnaps[n].name, "/palm/programs/spec/%s", fileName);
						n++;
					}
				}
				VFSFileClose(dirRef);
			}
		}
	}
	
	vfssnapsnum=n;
	FreeListSNA();
	lFirst = TRUE;
	
	while(DmGetNextDatabaseByTypeCreator
		  (lFirst, &ss, 'Data', 'PSPe', FALSE, &card, &id) == errNone) {
		lFirst = FALSE;
		n++;
	}
	
	list = MemPtrNew(sizeof(char *) * n);
	n = 0;
	lFirst = TRUE;
	
	while(DmGetNextDatabaseByTypeCreator
		  (lFirst, &ss, 'Data', 'PSPe', FALSE, &card, &id) == errNone) {
		lFirst = FALSE;
		list[n] = MemPtrNew(32);
		DmDatabaseInfo(card, id, list[n], NULL, NULL, NULL, NULL, NULL, NULL,
					   NULL, NULL, NULL, NULL);
		n++;
	}

	dbsnapsnum=n;
	for(i=0;i<vfssnapsnum; i++) {
		list[n] = MemPtrNew(32);
		getlistname(list[n], vfssnaps[i].name);
		n++;
	}
	nlist = n;
}

void ListSNA(void)
{
	ListType *lt;
	lt = FrmGetObjectPtr(FrmGetActiveForm(),
						 FrmGetObjectIndex(FrmGetActiveForm(), LIST_SNA));
	if(lt != NULL) {
		GetListSNA();
		LstSetListChoices(lt, list, nlist);
		LstDrawList(lt);
	}
}

