/* Emulation of the Z80 CPU with hooks into the other parts of z81.
 * Copyright (C) 1994 Ian Collier.
 * z81 changes (C) 1995-2001 Russell Marks.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define DEBUG 0
#define SNDBUFSIZE 441

#include "z80.h"
#include <PceNativeCall.h>
#include <Standalone.h>

#include "string.h"
#include "endian.h"
#include "armlet-ids.h"

#define parity(a) (partable[a])

STANDALONE_CODE_RESOURCE_ID(armz80_id);

#define in(h,l) ink(h,l,keyb)
#define out(h,l,a) outo(h,l,a,tstates,&out254,userData68KP,&pos)

unsigned char ink(int h, int l, unsigned char *k);
unsigned char outo(int h, int l, int a, int tstates, unsigned char *o, 
		unsigned char *userData68KP, int *pos);

void mainloop(const void *emulStateP, unsigned char *userData68KP,
			  Call68KFuncType * call68KFuncP)
{
	int cc;
	unsigned char a, f, b, c, d, e, h, l;
	unsigned char r, a1, f1, b1, c1, d1, e1, h1, l1, i, iff1, iff2, im;
	unsigned short pc;
	unsigned short ix, iy, sp;
	unsigned int radjust;
	unsigned char ixoriy, new_ixoriy;
	unsigned char intsample;
	unsigned char op;
	unsigned char *sc;
	unsigned char *memram, *memrom;
	unsigned int tstates, tsmax;
	unsigned char partable[256];
	unsigned int counter;
	unsigned char out254;
	int n;
	int pos;
	unsigned char keyb[9];

	sc = (unsigned char *)ReadUnaligned32(userData68KP + 0);
	pos=0;

	for(n = 0; n < 256; n += 16) {
		int j, l;
		l = 0x9669 & (1 << (n >> 4)) ? 0x9669 : 0x6996;
		for(j = 0; j < 16; j++) {
			partable[n + j] = 4 * (l & 1);
			l >>= 1;
		}
	}

	memram = (unsigned char *)ReadUnaligned32(userData68KP + 4);
	memrom = (unsigned char *)ReadUnaligned32(userData68KP + 8);
	tstates = ReadUnaligned32(userData68KP + 40);
	tsmax = ReadUnaligned32(userData68KP + 44);
	counter = ReadUnaligned32(userData68KP + 80);
	a = userData68KP[48];
	f = userData68KP[49];
	b = userData68KP[50];
	c = userData68KP[51];
	d = userData68KP[52];
	e = userData68KP[53];
	h = userData68KP[54];
	l = userData68KP[55];
	r = userData68KP[56] | 0x80;
	a1 = userData68KP[57];
	f1 = userData68KP[58];
	b1 = userData68KP[59];
	c1 = userData68KP[60];
	d1 = userData68KP[61];
	e1 = userData68KP[62];
	h1 = userData68KP[63];
	l1 = userData68KP[64];
	i = userData68KP[65];
	iff1 = userData68KP[66];
	iff2 = userData68KP[67];
	im = userData68KP[68];
	pc = ReadUnaligned16(userData68KP + 72);
	ix = ReadUnaligned16(userData68KP + 74);
	iy = ReadUnaligned16(userData68KP + 76);
	sp = ReadUnaligned16(userData68KP + 78);
	for(n = 0; n < 9; n++)
		keyb[n] = userData68KP[84 + n];
	out254 = userData68KP[96];
	
	userData68KP[100]=0;
	
	ixoriy = new_ixoriy = 0;
	tstates = radjust = 0;
	cc = 1;
	while(1) {
		ixoriy = new_ixoriy;
		new_ixoriy = 0;
		intsample = 1;
		if(!counter || !cc || !iff1) {
			op = fetch(pc);
			pc++;
		} else {
#if 0
			op = 0xff;
			cc = 0;
#else
			if(im!=2) {
				op = 0xff;			/* rst 38 */
				cc = 0;
			} else  {
				int a;
				sp-=2;
				iff1=0;
				store2(sp, pc);
				a=((unsigned int)i<<8)+255;
				pc=fetch2(a);
				tstates+=19;
				op=fetch(pc);
				pc++;
				cc=0;
			}
#endif
		}
		radjust++;

		switch (op) {
#include "z80ops.c"
		}
		if((tstates > tsmax) && !new_ixoriy) {
			userData68KP[48] = a;
			userData68KP[49] = f;
			userData68KP[50] = b;
			userData68KP[51] = c;
			userData68KP[52] = d;
			userData68KP[53] = e;
			userData68KP[54] = h;
			userData68KP[55] = l;
			userData68KP[56] = r;
			userData68KP[57] = a1;
			userData68KP[58] = f1;
			userData68KP[59] = b1;
			userData68KP[60] = c1;
			userData68KP[61] = d1;
			userData68KP[62] = e1;
			userData68KP[63] = h1;
			userData68KP[64] = l1;
			userData68KP[65] = i;
			userData68KP[66] = iff1;
			userData68KP[67] = iff2;
			userData68KP[68] = im;
			userData68KP[72] = pc >> 8;
			userData68KP[73] = pc & 0xff;
			userData68KP[74] = ix >> 8;
			userData68KP[75] = ix & 0xff;
			userData68KP[76] = iy >> 8;
			userData68KP[77] = iy & 0xff;
			userData68KP[78] = sp >> 8;
			userData68KP[79] = sp & 0xff;

			userData68KP[40] = tstates >> 24;
			userData68KP[41] = (tstates >> 16) & 0xff;
			userData68KP[42] = (tstates >> 8) & 0xff;
			userData68KP[43] = tstates & 0xff;

			userData68KP[96] = out254;

			memset(userData68KP+103+SNDBUFSIZE*userData68KP[102]+pos,
					                        userData68KP[100], SNDBUFSIZE-pos);
			
			return;
		}
	}
}

unsigned char ink(int h, int l, unsigned char *k)
{
	int i;
	unsigned char j;
	switch (l) {
	case 31:
		return k[8];
		break;
	case 254:
		j = 255;
		for(i = 0; i < 8; i++)
			if(!(h & (1 << i)))
				j &= k[i];
		return j;
		break;
	default:
		return 255;
	}
}

unsigned char outo(int h, int l, int a, int tstates, unsigned char *o, 
		unsigned char *userData68KP, int *pos)
{
	if(!(l & 1)) {
		*o = a;
#if 1
		{
			int p;
			unsigned char c=(a&0x10)<<1;
			p=tstates*1000/158731;
			if(p>*pos) {
				memset(userData68KP+103+SNDBUFSIZE*userData68KP[102]+*pos, 
						c, p-*pos);
			}
			userData68KP[100]=32-c;
			*pos=p;
		}
#endif
	}
	return 0;
}
