int filedump(unsigned char *target, int n, UInt32 pos, UInt32 len) {
	if(n<dbsnapsnum) {
		FileDump(target, list[n], pos, len);
	} else {
#if VFS 
		FileRef f;
		int err;
	
		err=VFSFileOpen(vfssnaps[n-dbsnapsnum]->volRefNum, vfssnaps[n-dbsnapsnum]->name,
				vfsModeRead, &f);
		if(err==errNone) {
			VFSFileSeek(f, vfsOriginBeginning, pos);
			VFSFileRead(f, len, target, NULL);
			VFSFileClose(f);
		} else {
			volatile UInt32 ww;
			char st[50];
			sprintf(st, "e=%04x n=%4i d=%4i", err, n, dbsnapsnum);
			WinDrawChars(st, 20, 10, 50);
			sprintf(st, "f=%08lx v=%04x", f, vfssnaps[n-dbsnapsnum]->volRefNum);
			WinDrawChars(st, 17, 10, 80);
			WinDrawChars(vfssnaps[n-dbsnapsnum]->name+5, 
					StrLen(vfssnaps[n-dbsnapsnum]->name+5), 1, 100);
			sprintf(st, "pos=%7li len=%7li", pos, len);
			WinDrawChars(st, 23, 10, 120);
			for(ww=0;ww<2500000;ww++);
			return 1;
		}
#endif
	}
	return 0;
}

void getkeys(int n, struct prefs_t *prefs, unsigned char *k) {
	int i;
	if(!prefs->global) {
		if(k[0]==144) {
			/* Check the loaded key definitions */
			if(dhk) {
				i=0;
				while(dhk[i].name[0]) {
					if(StrCaselessCompare(dhk[i].name, list[n])==0) {
						MemMove(prefs->hardkeys, dhk[i].keys, 9);
						return ;
					}
					i++;
				}
			}

			/* Check built in key definitions */
			i=0;
			while(hkeys[i].name[0]) {
				if(StrCaselessCompare(hkeys[i].name, list[n])==0) {
					MemMove(prefs->hardkeys, hkeys[i].keys, 9);
					return;
				}
				i++;
			}
		} else {
			MemMove(prefs->hardkeys, k, 9);
		}
	}

}

#define DATASIZE 60000

void loadz80(int n, struct prefs_t *prefs) {
	unsigned char s[55];
	unsigned char k[10];
	unsigned char *data;
	int i;
	int z80v;
	UInt32 p, q;

	for(i=0;i<9;i++)k[i]=144+i;

	data=MemPtrNew(DATASIZE);
	if(!data) return;
	
	z80v=0;
	
	filedump(s, n, 0, 30);
	
	q=30;

	armshared.a = s[0];
	armshared.f = s[1];
	armshared.b = s[3];
	armshared.c = s[2];
	armshared.d = s[14];
	armshared.e = s[13];
	armshared.h = s[5];
	armshared.l = s[4];
	armshared.r = 0x80&(s[12]<<7);
	armshared.i = i;
	armshared.im = s[29]&3;
	armshared.iff1 = s[27];
	armshared.iff2 = s[28];
	armshared.sp = s[8]+256*s[9];
	armshared.ix = s[25]+256*s[26];
	armshared.iy = s[23]+256*s[24];
	armshared.a1 = s[21];
	armshared.f1 = s[22];
	armshared.b1 = s[16];
	armshared.c1 = s[15];
	armshared.d1 = s[18];
	armshared.e1 = s[17];
	armshared.h1 = s[20];
	armshared.l1 = s[19];
	armshared.out254 &= 0xf8;
	armshared.out254 |= (s[12]>>1)&7;
	armshared.pc = s[6]+256*s[7];

	if(armshared.pc==0) {
		unsigned char c, d;

		z80v=1;
		
		filedump(&c, n, 30, 1);
		filedump(&d, n, 31, 1);
		q=(c+256*d);
		filedump(s, n, 32, (q>54 ? 54:q));
		q+=32;
		filedump(data, n, q, 60000);

		armshared.pc = s[0] + 256*s[1];	
	} else {
		z80v=0;
		filedump(data, n, 30, 60000);
	}

	q=0;
	if(z80v==1) {
		UInt32 size;
		for(i=0;i<3;i++) {
			size=data[q]+256*data[q+1];
			q+=2;
			switch(data[q]) {
				case 8:
					p=0;
					break;
				case 4:
					p=0x4000;
					break;
				case 5:
					p=0x8000;
					break;
				default:
					p=0;
			}
			q++;
			while(size>0) {
				size--;
				if(q>=DATASIZE || p>=0xc000) {
					MemPtrFree(data);
					return ;
				}
				if(data[q]==0xed && data[q+1]==0xed) {
					if(p+data[q+2]>=0xc000) {
						MemPtrFree(data);
						return ;
					}
					MemSet(memram+p, data[q+2], data[q+3]);
					p+=data[q+2];
					q+=4;
					size-=3;
				} else {
					memram[p]=data[q];
					p++;
					q++;
				}
			}
		}
	} else if(z80v==0) {
		p=0;
		q=0;
		while(p<0xc000) {
			if(data[q]==0xed && data[q+1]==0xed) {
				MemSet(memram+p, data[q+2], data[q+3]);
				p+=data[q+2];
				q+=4;
			} else {
				memram[p]=data[q];
				p++;
				q++;
			}
		}
	}
		
	MemPtrFree(data);
	getkeys(n, prefs, k);

}


void loadsna(int n, struct prefs_t *prefs) {
	unsigned char s[28];
	unsigned char k[10];
	int i;

	for(i=0;i<9;i++)k[i]=144+i;

	if(filedump(s, n, 0, 27)) return;
	filedump(memram, n, 27, 49152);
	filedump(k, n, 27+49152, 9);

	armshared.a = s[22];
	armshared.f = s[21];
	armshared.b = s[14];
	armshared.c = s[13];
	armshared.d = s[12];
	armshared.e = s[11];
	armshared.h = s[10];
	armshared.l = s[9];
	armshared.r = s[20];
	armshared.i = s[0];
	armshared.im = s[25];
	armshared.iff1 = (s[19]&4)>>2;
	armshared.iff2 = (s[19]&4)>>2;
	armshared.sp = s[23]+256*s[24];
	armshared.ix = s[17]+256*s[18];
	armshared.iy = s[15]+256*s[16];
	armshared.a1 = s[8];
	armshared.f1 = s[7];
	armshared.b1 = s[6];
	armshared.c1 = s[5];
	armshared.d1 = s[4];
	armshared.e1 = s[3];
	armshared.h1 = s[2];
	armshared.l1 = s[1];
	armshared.out254 &= 0xf8;
	armshared.out254 |= s[26]&7;
	armshared.pc = memram[armshared.sp-0x4000]+256*memram[armshared.sp-0x3fff];
	armshared.sp += 2;
	
	getkeys(n, prefs, k);
}

void savesna(char *name, struct prefs_t *prefs) {
	unsigned char s[28];
	unsigned char s1, s2;

	s[22] = armshared.a;
	s[21] = armshared.f;
	s[14] = armshared.b;
	s[13] = armshared.c;
	s[12] = armshared.d;
	s[11] = armshared.e;
	s[10] = armshared.h;
	s[9] = armshared.l;
	s[20] = armshared.r;
	s[0] = armshared.i;
	s[25] = armshared.im;
	s[19] = armshared.iff1<<2;
	s[8] = armshared.a1;
	s[7] = armshared.f1;
	s[6] = armshared.b1;
	s[5] = armshared.c1;
	s[4] = armshared.d1;
	s[3] = armshared.e1;
	s[2] = armshared.h1;
	s[1] = armshared.l1;
	s[26] = armshared.out254 & 7;
	armshared.sp-=2;
	s1=memram[armshared.sp-0x4000];
	s2=memram[armshared.sp-0x3fff];
	memram[armshared.sp-0x4000]=armshared.pc&0xff;
	memram[armshared.sp-0x3fff]=(armshared.pc>>8)&0xff;
	s[23]=armshared.sp&0xff;
	s[24]=(armshared.sp>>8)&0xff;
	s[15]=armshared.iy&0xff;
	s[16]=(armshared.iy>>8)&0xff;
	s[17]=armshared.ix&0xff;
	s[18]=(armshared.ix>>8)&0xff;

	FileCreate(TMP_FILE, 49152+27+9);
	filewrite(TMP_FILE, s, 0, 27, 0);
	filewrite(TMP_FILE, memram, 27, 49152, 0);
	filewrite(TMP_FILE, prefs->hardkeys, 27+49152, 9, 0);

	memram[armshared.sp-0x4000]=s1;
	memram[armshared.sp-0x3fff]=s2;
	armshared.sp+=2;
}

void FreeListSNA(void)
{
	int n;
	if(nlist) {
		for(n = 0; n < nlist; n++) {
			MemPtrFree(list[n]);
		}
		MemPtrFree(list);
		nlist = 0;
		for(n=0;n<MAXVFSSNAPS;n++)if(vfssnaps[n]) MemPtrFree(vfssnaps[n]);
	}
	
}

void getlistname(char *ln, const char *n, UInt16 *v) {
	int i, l;

	*v=1;
	l=StrLen(n);
	i=l-1;
	while(i && n[i]!='/')i--;
	i++;
	if(l-i>31)i=l-31;
	if(StrCaselessCompare(n+l-4, ".sna")==0) {
		l-=4;
	}
	if(StrCaselessCompare(n+l-4, ".z80")==0) {
		l-=4;
		*v=2;
	}
	StrNCopy(ln, n+i, l-i);
	ln[l-i]='\0';
}

void GetListSNA(void)
{
	int lFirst;
	DmSearchStateType ss;
	UInt16 card;
	LocalID id;
	int n = 0;
#if VFS
	FileRef f;
	int i, err;
	FileRef dirRef;
	UInt16 volRefNum; 
	UInt32 volIterator;
	
	volIterator = vfsIteratorStart; 
	
	for(i=0;i<MAXVFSSNAPS;i++)vfssnaps[i]=NULL;
	
	while (volIterator != vfsIteratorStop) { 
		err = VFSVolumeEnumerate(&volRefNum, &volIterator); 
		if (err == errNone) {
			err = VFSFileOpen(volRefNum, "/palm/programs/spec", vfsModeRead, &dirRef); 
			if(err == errNone) {  
				UInt32 fileIterator; 
				FileInfoType fileInfo; 
				char fileName[128];  

				fileInfo.nameP = fileName;
				fileInfo.nameBufLen = 128;
				fileIterator = vfsIteratorStart;
				while ( (fileIterator != vfsIteratorStop) && 
						(err==errNone) && (n<MAXVFSSNAPS) ){
			
					err = VFSDirEntryEnumerate(dirRef, &fileIterator, &fileInfo);
					if(err == errNone && !(fileInfo.attributes&vfsFileAttrDirectory)) {
						vfssnaps[n]=MemPtrNew(sizeof(struct vfssnap));
						vfssnaps[n]->volRefNum=volRefNum;
						sprintf(vfssnaps[n]->name, "/palm/programs/spec/%s", fileName);
						n++;
					}
				}
				VFSFileClose(dirRef);
			}
		}
	}
#endif /* VFS */
	vfssnapsnum=n;
	FreeListSNA();
	lFirst = TRUE;
	
	while(DmGetNextDatabaseByTypeCreator
		  (lFirst, &ss, 'Data', 'PSPe', FALSE, &card, &id) == errNone) {
		lFirst = FALSE;
		n++;
	}
	
	list = MemPtrNew(sizeof(char *) * n);
	snapver = MemPtrNew(sizeof(UInt16) * n);
	n = 0;
	lFirst = TRUE;
	
	while(DmGetNextDatabaseByTypeCreator
		  (lFirst, &ss, 'Data', 'PSPe', FALSE, &card, &id) == errNone) {
		lFirst = FALSE;
		list[n] = MemPtrNew(32);
		DmDatabaseInfo(card, id, list[n], NULL, &snapver[n], NULL, NULL, NULL, NULL,
					   NULL, NULL, NULL, NULL);
		if( StrCaselessCompare(list[n], "ArmPalmSpecKeyDef") && 
			StrCaselessCompare(list[n], "SpectrumRom") )
			n++;
	}
	snapver[0]=1;

	dbsnapsnum=n;
#if VFS
	if(vfssnapsnum>0) { /* Without this, VFS fails catastrophically */
		if((err=VFSFileOpen(vfssnaps[0]->volRefNum, vfssnaps[0]->name, vfsModeRead, &f))==errNone) {
			VFSFileClose(f); 
		} else {
			volatile UInt32 ww;
			char st[50];
			sprintf(st, "e=%04x", err);
			WinDrawChars(st, 6, 10, 120);
			for(ww=0;ww<1000000;ww++);
		}
	}

	for(i=0;i<vfssnapsnum; i++) {
		list[n] = MemPtrNew(32);
		getlistname(list[n], vfssnaps[i]->name, &snapver[n]);
		n++;
	}

#endif /* VFS */
	nlist = n;
}

void ListSNA(void)
{
	ListType *lt;
	lt = FrmGetObjectPtr(FrmGetActiveForm(),
						 FrmGetObjectIndex(FrmGetActiveForm(), LIST_SNA));
	if(lt != NULL) {
		GetListSNA();
		LstSetListChoices(lt, list, nlist);
		LstDrawList(lt);
	}
}

void loadsnap(int n, struct prefs_t *prefs) {
	switch(snapver[n]) {
		case 1:
			loadsna(n, prefs);
			break;
		case 2:
			loadz80(n, prefs);
			break;
	}
}

void savesnap(char *name, struct prefs_t *prefs) {
	savesna( name, prefs);
}
