#include <PceNativeCall.h>
#include <Standalone.h>

#include "endian.h"
#include "armlet-ids.h"

#define WriteUnaligned32(v,a) \
	*(unsigned char *)(a) = (v)>>24; \
	*(unsigned char *)((a)+1) = (v&0xff0000)>>16; \
	*(unsigned char *)((a)+2) = (v&0xff00)>>8; \
	*(unsigned char *)((a)+3) = (v&0xff)

STANDALONE_CODE_RESOURCE_ID (add_id);

unsigned long start (const void *emulStateP, char *userData68KP,
		     Call68KFuncType *call68KFuncP) {
  unsigned long a = ReadUnaligned32 (userData68KP);
  unsigned long b = ReadUnaligned32 (userData68KP + 4);

  unsigned long r;


//  *(unsigned long *)0xfffec500=0xffffff00;
  r=*(unsigned char *)0xfffb4800; /* RTC */
  WriteUnaligned32(r, userData68KP + 8);

  r=*(unsigned char *)0xfffb4804;
  WriteUnaligned32(r, userData68KP + 12);
  
  r=*(unsigned char *)0xfffb4808;
  WriteUnaligned32(r, userData68KP + 16);
 
  r=*(unsigned short *)0xfffecf00; /* dpll1 */
  WriteUnaligned32(r, userData68KP + 20);

  r=*(unsigned short *)0xfffece00;
  WriteUnaligned32(r, userData68KP + 24);
  
  r=0xfffec608;
  WriteUnaligned32(r, userData68KP + 28);

  r=*(unsigned long *)0xfffec500; /* timer 1 */
  WriteUnaligned32(r, userData68KP + 32);

  r=*(unsigned long *)0xfffec504;
  WriteUnaligned32(r, userData68KP + 36);
  
  r=*(unsigned long *)0xfffec508;
  WriteUnaligned32(r, userData68KP + 40);
  
  return a + b;
}
