static inline unsigned long ReadUnaligned32 (const void *pv) {
  const unsigned char *p = pv;
  return (p[0] << 24) | (p[1] << 16) | (p[2] << 8) | p[3];
  }

#if 1
static inline unsigned long ByteSwap32 (unsigned long r0) {
  unsigned long r1;

  r1 = r0 ^ ((r0 >> 16) | (r0 << 16));
  r1 &= ~0xff0000ul;
  r0 = (r0 >> 8) | (r0 << 24);
  r0 ^= r1 >> 8;

  return r0;
  }

#else

#define ByteSwap32(n)				\
  ({ unsigned long r0 = (n), r1;		\
     r1 = r0 ^ ((r0 >> 16) | (r0 << 16));	\
     r1 &= ~0xff0000ul;				\
     r0 = (r0 >> 8) | (r0 << 24);		\
     r0 ^= r1 >> 8;				\
     r0; })

#endif
